<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

class ControllerExtensionModuleLINELogin extends Controller {
	public function index() {
		require_once(DIR_SYSTEM . 'library/linebiz/ConfigManager.php');
		require_once(DIR_SYSTEM . 'library/linebiz/LineAuthorization.php');
		require_once(DIR_SYSTEM . 'library/linebiz/LineProfiles.php');
		require_once(DIR_SYSTEM . 'library/linebiz/LineController.php');

		define("CLIENT_ID", $this->config->get('module_linelogin_client_id'));
		define("CLIENT_SECRET", $this->config->get('module_linelogin_client_secret'));
		define("REDIRECT_URI", HTTPS_SERVER . 'index.php?route=extension/module/linelogin/login');
		define("SCOPE", 'profile%20openid%20email');

		$this->load->language('extension/module/linelogin');

		$state = sha1(time());
		$this->session->data['line_state'] = $state;
		$Line = new LineController();

		$data = array();

		if ($this->config->get('module_linelogin_status')) {
			$data['line_login_url'] = $Line->lineLogin($state);
		} else {
			$data['line_login_url'] = '';
		}

		return $this->load->view('extension/module/linelogin', $data);
	}

	public function login() {
		require_once(DIR_SYSTEM . 'library/linebiz/ConfigManager.php');
		require_once(DIR_SYSTEM . 'library/linebiz/LineAuthorization.php');
		require_once(DIR_SYSTEM . 'library/linebiz/LineProfiles.php');
		require_once(DIR_SYSTEM . 'library/linebiz/LineController.php');

		define("CLIENT_ID", $this->config->get('module_linelogin_client_id'));
		define("CLIENT_SECRET", $this->config->get('module_linelogin_client_secret'));
		define("REDIRECT_URI", HTTPS_SERVER . 'index.php?route=extension/module/linelogin/login');
		define("SCOPE", 'profile%20openid%20email');

		if(isset($this->session->data['route'])) {
			$location = $this->url->link($this->session->data['route'], "", true);
		} else {
			$location = $this->url->link("account/account", "", true);
		}
		
		if ($this->customer->isLogged())	
			$this->response->redirect($location);

		// ---
		$Line = new LineController();

		if (isset($_COOKIE['access_token'])) {
			$access_token = $_COOKIE['access_token'];
		} elseif (isset($_GET['code']) && isset($_GET['state'])) {
			$code = $_GET['code'];
			$state = $_GET['state'];
			$profile = $Line->getAccessToken($code);
		} else {
			$this->response->redirect($location); 
		}

		if ($profile) {

			$this->load->model('account/customer');

			$customer_info = $this->model_account_customer->getCustomerByLINEProfile($profile);
			
			// Login
			if (!empty($customer_info)) {
				if (!$customer_info['status']) {
					$this->session->data['warning'] = '帳號尚未啟用';
				} else {
					if ($this->customer->login($customer_info['email'], '', true)) {
						if (substr($customer_info['email'], -5) == '@line') {
							$location = $this->url->link("account/edit", "alert_type=account_data", true);
						}
						$this->response->redirect($location);
					}
				}

			// Register
			} else {
				$salt = token(9);
				$password = (string)time() . '@line';
				if (isset($profile['email']) && $profile['email']) {
					$email = $profile['email'];
				} else {
					$email = $profile['email'] . '@line';
				}
				$customerdata = array();
				$customerdata['line_userid'] = $profile['sub'];
				$customerdata['email'] = $email;
				$customerdata['password'] = SHA1($salt . SHA1($salt . SHA1($password)));
				$customerdata['salt'] = $salt;
				$customerdata['firstname'] = $profile['name'];
				$customerdata['lastname'] = '';
				$customerdata['fax'] = '';
				$customerdata['telephone'] = '';
				$customerdata['company'] = '';
				$customerdata['company_id'] = '';
				$customerdata['tax_id'] = '';
				$customerdata['address_1'] = '';
				$customerdata['address_2'] = '';
				$customerdata['city'] = '';
				$customerdata['city_id'] = '';
				$customerdata['postcode'] = '';
				$customerdata['country_id'] = 0;
				$customerdata['zone_id'] = 0;
				$this->model_account_customer->addSocialCustomer($customerdata);

				if ($this->customer->login($email, $password, true)) {
					$location = $this->url->link("account/edit", "alert_type=account_data", true);
					$this->response->redirect($location);
				}
			}


		} else {
			
			$this->session->data['warning'] = '登入失敗';
		}

		$location = $this->url->link("account/login", "", true);
		
		$this->response->redirect($location);
		
	}
	
}